<html lang="en-US">
<head>
	<link href="css/style.css?v=10" media="all" rel="stylesheet" />  
	<title>Marilena Cafe + Raw Bar - Toptable Group</title>

	 <link rel="stylesheet" href=https://use.typekit.net/ucw7taj.css>
	 <link rel="stylesheet" href="https://use.typekit.net/hyd1huq.css">
	 <meta name="viewport" content="width=device-width, initial-scale=1" />
	 <script src="https://kit.fontawesome.com/8ecb07e518.js" crossorigin="anonymous"></script>
</head><body>

<?php include('inc/header.php'); ?>

<div class="banner inner about"><div class="middle"></div></div>
<div class="section">
	<div class="container">
		
		<h2>About Marilena</h2>
		<p>From the team behind Vancouver’s award-winning restaurants Blue Water Cafe, Elisa, CinCin, Whistler’s Araxi, Il Caminetto and Bar Oso, as well as New York City’s Oceans and Carlotto, Toptable Group opens its first restaurant in the heart of BC’s beautiful capital city, Victoria – Marilena.</p>
                <p>An avid free diver and fisherman, Executive Chef Eligh returns to his hometown with a menu that draws inspiration from memorable West Coast cuisine with an emphasis on local and globally sourced seafood.</p>
                <p>Marilena features local and global seafood paired with high-quality sustainable ingredients that adhere to the highest standards. Guests can choose from a selection of nigiri, sashimi and sushi rolls at our stunning Japanese raw bar led by Chef Clark Park.</p>
                <p>Our front-of-house team, led by Restaurant Director Aaron Matsuzaki, is passionate about delivering an unparalleled level of hospitality set within Marilena’s warm, contemporary dining room anchored by an open concept kitchen.</p>
                <p>Marilena’s expansive wine list celebrates far-reaching varietals from notable regions while also honouring the Island’s premier wineries.</p>
	</div>
</div>

<div class="section staff">
	<div class="container">
                <div class="member">
                        <div class="image"><img src="img/marilena-cafe-kristian-eligh.jpg" alt="Kristian Eligh, Executive Chef" /></div>
                        <div class="content">
                                <h3>Kristian Eligh, <span class="blockOnPhone">Executive Chef</span></h3>
                                <p>Returning to his hometown of Victoria, Executive Chef Kristian Eligh leads our culinary team at Marilena Cafe and Raw Bar. Prior to our opening, Chef Kristian held positions in world renowned Michelin starred restaurants like Jean George in New York City, The French Laundry in Napa and Blackbird in Chicago. Most recently, Chef Kristian spent six years as Culinary Director for Vancouver based Hawksworth Restaurant Group, leading the Nightingale and Hawksworth teams respectively, achieving accolades such as Vancouver Magazine’s Chef of the Year in 2011 and 2012.</p>
                                <p>An avid free-diver and fisherman, Chef Kristian brings his passion for coastal cuisine to Marilena Cafe. Inspired by local offerings, his approachable dishes celebrate global flavours accented by seasonal ingredients, creating an unforgettable dining experience for our guests. Chef Kristian looks forward to delivering a hospitality experience that speaks to the Victoria community and to be able to contribute to the growing dining scene on Vancouver Island.</p>
                        </div>
                </div>
                <div class="member" style="display:none">
                        <div class="image"><img src="img/tempimage.jpg" alt="Aaron Matsuzaki, Restaurant Manager" /></div>
                        <div class="content">
                                <h3>Aaron Matsuzaki, <span class="blockOnPhone">Restaurant Manager</span></h3>
                                <p>Originally from Richmond, British Columbia, our dedicated Restaurant Director Aaron Matsuzaki leads our front-of-house team at Marilena Cafe and Raw Bar. Aaron joins us with eighteen years of hospitality experience, previously holding senior positions at established Vancouver restaurants Nancy Go Yaya and MIKU, prior to moving to Victoria in 2022 to open Marilena Cafe.</p>
                                <p>Inspired by our passionate team, Aaron looks forward to welcoming the Victoria community and delivering an unparalleled hospitality experience for our guests.</p>
                        </div>
                </div>
                <div class="member" style="display:none">
                        <div class="image"><img src="img/tempimage.jpg" alt="Clark Park, Sushi Chef" /></div>
                        <div class="content">
                                <h3>Clark Park, <span class="blockOnPhone">Sushi Chef</span></h3>
                                <p>Sushi Chef Clark Park joins the Marilena Cafe and Raw Bar team with eighteen years of hospitality experience. Originally from Seoul Korea, Chef Clark has worked as Sous Chef at MIKU in Vancouver, and most recently as General Manager and Head Chef at Yua Bistro in Victoria.</p>
                                <p>Chef Clark looks forward to sharing his passion for hospitality and welcoming guests to experience his signature Marilena Cafe raw bar creations. </p>
                        </div>
                </div>
                <div class="member" style="display:none">
                        <div class="image"><img src="img/tempimage.jpg" alt="Dominique Laurencelle, Pastry Chef" /></div>
                        <div class="content">
                                <h3>Dominique Laurencelle, <span class="blockOnPhone">Pastry Chef</span></h3>
                                <p>Originally from Winnipeg, our Pastry Chef Dominique Laurencelle brings twenty-two years of hospitality experience to Marilena Cafe and Raw Bar. Prior to moving to Victoria in 2019 to join the Boom + Batten team, Chef Dominique held positions all over Western in Canada including Kelowna, Whistler and Langara Island.</p>
                                <p>Chef Dominique is excited to welcome guests and share her passion for creating stunning pastries and desserts with the Victoria community.</p>
                        </div>
                </div>
                <div class="member" style="display:none">
                        <div class="image"><img src="img/tempimage.jpg" alt="Jayce Kadyschuk, Bar Manager" /></div>
                        <div class="content">
                                <h3>Jayce Kadyschuk, <span class="blockOnPhone">Bar Manager</span></h3>
                                <p>Jayce has been a member of the hospitality industry throughout Western Canada for over twenty-two years.  In 2013, he moved to Victoria, B.C to lean into professional cocktail bartending and take on the Head Bartender position at Clive’s Classic Lounge in the Chateau Victoria. Under Jayce’s leadership, Clive’s secured three “Top Ten World’s Best Hotel Bar” nominations (Tales of the Cocktail – Spirited Awards 2014, 2019, 2020). In 2021, Jayce joined the Marilena Cafe and Raw bar team as our Bar Manager to develop our beverage program and looks forward to creating an unforgettable experience for our guests.</p>
                        </div>
                </div>                                                                
	</div>
</div>

<?php include('inc/googlemaps.php'); ?>
 
<?php include('inc/footer.php'); ?>

</div></body>
</html>